VERSION 5.00
Begin VB.Form Tankconflict 
   BackColor       =   &H00000000&
   BorderStyle     =   0  '
   Caption         =   "Tank Conflict"
   ClientHeight    =   3195
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4680
   ForeColor       =   &H00000000&
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MousePointer    =   1  '
   ScaleHeight     =   3195
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
End
Attribute VB_Name = "Tankconflict"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Keyboard commands
Const KEY1_RIGHT = &H1
Const KEY1_DOWN = &H2
Const KEY1_LEFT = &H4
Const KEY1_UP = &H8
Const KEY1_FIRE = &H10
Const KEY2_RIGHT = &H20
Const KEY2_DOWN = &H40
Const KEY2_LEFT = &H80
Const KEY2_UP = &H100
Const KEY2_FIRE = &H200

' Game parameters
Const FIRE_DELAY = 20       ' Delay between shots
Const BULLET_RADIUS = 12    ' Radius of the bullets
Const MAX_BULLETS = 5       ' Maximum number of bullets for a player

' Structures
Private Type cCloud
    x As Integer
    y As Integer
End Type

Private Type cPlayer
    x As Integer            ' Player's horizontal coordinate
    y As Integer            ' Player's vertical coordinate
    direction As Integer    ' Player's current direction
    power As Integer        ' Player's power left
    bullets As Integer      ' Player's number of bullets
    fired As Integer        ' Bullets fired by player
    wheels As Integer       ' Tanks's wheels position
    firetime As Integer     ' Time since fired
End Type

Private Type cBullet
    x As Integer
    y As Integer
    xvel As Integer
    yvel As Integer
    owner As Integer
    lifetime As Integer
End Type

Private Type cBonusitem
    x As Integer
    y As Integer
    time As Integer
End Type

' Global variables
Dim cloud(20) As cCloud
Dim player(2) As cPlayer
Dim bullet(MAX_BULLETS * 2) As cBullet
Dim bonus As cBonusitem

Dim dx As New DirectX7
Dim dd As DirectDraw7
Dim Primary As DirectDrawSurface7
Dim Back As DirectDrawSurface7
Dim Achter As DirectDrawSurface7
Dim Sprites As DirectDrawSurface7
Dim Intro As DirectDrawSurface7
Dim ddsd1 As DDSURFACEDESC2
Dim ddsd2 As DDSURFACEDESC2

Dim m_ds As DirectSound               ' Sound object
Dim hsoShoot As DirectSoundBuffer
Dim hsoHit As DirectSoundBuffer
Dim hsoBounce As DirectSoundBuffer
Dim hsoBounce2 As DirectSoundBuffer   ' We need another buffer to play sound of both players simultaneously
Dim hsoExplode As DirectSoundBuffer
Dim hsoBonus As DirectSoundBuffer

Dim bInit As Boolean
Dim bActive As Boolean
Dim bKeyPressed As Boolean
Dim bRevStereo As Boolean
Dim bSound As Boolean
Dim ExplosionState As Integer
Dim LastInput As Long
Dim bField(20, 14) As Boolean
Dim TimeTicks As Long

Dim WinningPlayer As Integer
Dim GameState As Integer        ' 0 - intro picture
                                ' 1 - playing game
                                ' 2 - tank burning

Sub InitSound()
    On Local Error Resume Next
    
    Set m_ds = dx.DirectSoundCreate("")
    
    If Err.Number <> 0 Then
        MsgBox "Unable to start DirectSound. Check to see that your sound card is properly installed"
        End
    End If
 
    m_ds.SetCooperativeLevel Me.hWnd, DSSCL_NORMAL
    
    Dim bufferDesc As DSBUFFERDESC
    Dim waveFormat As WAVEFORMATEX
    
    bufferDesc.lFlags = DSBCAPS_CTRLPAN
    
    Set hsoShoot = m_ds.CreateSoundBufferFromFile("Shoot.wav", bufferDesc, waveFormat)
    If Err.Number <> 0 Then
        MsgBox "unable to find Shoot.wav"
        End
    End If
    Set hsoHit = m_ds.CreateSoundBufferFromFile("Hit.wav", bufferDesc, waveFormat)
    If Err.Number <> 0 Then
        MsgBox "unable to find Hit.wav"
        End
    End If
    Set hsoBounce = m_ds.CreateSoundBufferFromFile("Bounce.wav", bufferDesc, waveFormat)
    If Err.Number <> 0 Then
        MsgBox "unable to find Bounce.wav"
        End
    End If
    Set hsoBounce2 = m_ds.CreateSoundBufferFromFile("Bounce.wav", bufferDesc, waveFormat)
    If Err.Number <> 0 Then
        MsgBox "unable to find Bounce.wav"
        End
    End If
    Set hsoExplode = m_ds.CreateSoundBufferFromFile("Explode.wav", bufferDesc, waveFormat)
    If Err.Number <> 0 Then
        MsgBox "unable to find Explode.wav"
        End
    End If
    Set hsoBonus = m_ds.CreateSoundBufferFromFile("Bonus.wav", bufferDesc, waveFormat)
    If Err.Number <> 0 Then
        MsgBox "unable to find Bonus.wav"
        End
    End If
End Sub

Sub InitVariables()
    Dim k As Integer
    
    GameState = 1
    
    player(0).x = 1
    player(0).y = 33
    player(0).direction = 8
    player(0).power = 12
    player(0).bullets = 1
    player(0).fired = 0

    player(1).x = 601
    player(1).y = 441
    player(1).direction = 12
    player(1).power = 12
    player(1).bullets = 1
    player(1).fired = 0

    For k = 0 To 19
        cloud(k).y = 0
    Next k
    For k = 0 To (MAX_BULLETS * 2) - 1
        bullet(k).lifetime = 0
    Next k

    bonus.time = 0
    ExplosionState = 0
End Sub

Sub InitLevel()
    Dim rcRect As RECT
    Dim ddrval As Long
    Dim r, s, xx, yy, x, y, k As Integer
    
    InitVariables

    For y = 0 To 13 ' clear bField
        For x = 0 To 19
            bField(x, y) = False
        Next x
    Next y

    For k = 0 To 19 ' draw up to 20 lines
        r = Int(3 * Rnd)        ' type of line
        s = Int((18 * Rnd) + 1)   ' length of line
        xx = Int(20 * Rnd)      ' start x coordinate
        yy = Int(14 * Rnd)      ' start y coordinate

        If r = 1 Then   ' draw horizontal line
            If xx + s > 19 Then ' check if not outside borders
                s = 19 - xx
            End If

            For x = 0 To s - 1 ' draw line
                bField(xx + x, yy) = True
            Next x
        End If
        
        If r = 2 Then ' draw vertical line
            If yy + s > 13 Then ' check if not on player startpoints
                s = 13 - yy
            End If

            For y = 0 To s  ' draw line
                bField(xx, yy + y) = True
            Next y
        End If
    Next k
    ' Remove player places and make way from player to player
    bField(0, 0) = False
    bField(19, 13) = False

    xx = 0
    yy = 0

    While xx < 19 Or yy < 13
        r = Int(2 * Rnd)
        If r = 0 Then
            If xx < 19 Then
                xx = xx + 1
                bField(xx, yy) = False
            End If
        End If
        If r = 1 Then
            If yy < 13 Then
                yy = yy + 1
                bField(xx, yy) = False
            End If
        End If
    Wend

    r = Int(4 * Rnd)   ' type of background
    s = Int(12 * Rnd)  ' type of foreground

    For yy = 0 To 13
        For xx = 0 To 19
            If bField(xx, yy) = True Then
                rcRect.Left = 32 * s
                rcRect.Top = 156
                rcRect.Right = rcRect.Left + 32
                rcRect.Bottom = rcRect.Top + 32
            Else
                rcRect.Left = 32 * (r + 12)
                rcRect.Top = 156
                rcRect.Right = rcRect.Left + 32
                rcRect.Bottom = rcRect.Top + 32
            End If

            ddrval = Achter.BltFast(xx * 32, yy * 32 + 32, Sprites, rcRect, DDBLTFAST_NOCOLORKEY Or DDBLTFAST_WAIT)
        Next xx
    Next yy
End Sub

Sub CollisionCheck()
    Dim k, l As Integer
    For k = 0 To 1
        For l = 0 To 9
            If bullet(l).lifetime > 0 Then
                If Abs((bullet(l).x + 5) - (player(k).x + 19)) < 19 And Abs((bullet(l).y + 5) - (player(k).y + 19)) < 19 Then
                    If bSound = True Then
                        hsoHit.Stop
                        hsoHit.SetCurrentPosition 0
                        PlayPanned hsoHit, player(k).x
                    End If
                    player(k).power = player(k).power - 1
                    bullet(l).lifetime = 0
                    player(bullet(l).owner).fired = player(bullet(l).owner).fired - 1
                    If player(k).power = 0 Then
                        If bSound = True Then
                            PlayPanned hsoExplode, player(k).x
                        End If
                        WinningPlayer = (1 - k)
                        GameState = 2
                    End If
                End If
            End If
        Next l
    Next k
End Sub

'
' play a sound, but first set the panning according to where the
' object is on the screen.  fake 3D sound.
'
Sub PlayPanned(hSo As DirectSoundBuffer, x As Integer)
    If bRevStereo = True Then
        hSo.SetPan 10000 - 20000 * (x / 640)
    Else
        hSo.SetPan 20000 * (x / 640) - 10000
    End If
    hSo.Play 0
End Sub

' Blit the energy beam and the number of bullets
Sub BlitScore()
    Dim rcRect As RECT
    Dim ddrval As Long
    Dim k, l As Integer
    
    For k = 0 To 1
        ' update power beam
        For l = 0 To player(k).power - 1
            rcRect.Left = 15 + k * 22
            rcRect.Top = 188
            rcRect.Right = 30 + k * 22
            rcRect.Bottom = 201

            ddrval = Back.BltFast(135 + (k * 320) + (l * 10), 10, Sprites, rcRect, DDBLTFAST_SRCCOLORKEY Or DDBLTFAST_WAIT)
        Next l
        ' update number of bullets
        For l = 0 To player(k).bullets - 1
            rcRect.Left = 58 + k * 13
            rcRect.Top = 189
            rcRect.Right = 70 + k * 13
            rcRect.Bottom = 201
        
            ddrval = Back.BltFast(270 + (k * 320) + (l * 5), 10, Sprites, rcRect, DDBLTFAST_SRCCOLORKEY Or DDBLTFAST_WAIT)
        Next l
    Next k
End Sub

Sub UpdateTanks()
    Dim ddrval As Long
    Dim rcRect As RECT
    Dim k As Integer
        
    For k = 0 To 1
        rcRect.Left = 78 * (player(k).direction Mod 8) + (39 * player(k).wheels)
        rcRect.Top = 78 * k + 39 * Int(player(k).direction / 8)
        rcRect.Right = rcRect.Left + 39
        rcRect.Bottom = rcRect.Top + 39

        ddrval = Back.BltFast(player(k).x, player(k).y, Sprites, rcRect, DDBLTFAST_SRCCOLORKEY Or DDBLTFAST_WAIT)
    Next k
End Sub

Sub ShowIntroPic()
    Dim ddrval As Long
    Dim rcRect As RECT

    rcRect.Left = 0
    rcRect.Top = 0
    rcRect.Right = 640
    rcRect.Bottom = 480

    ddrval = Back.BltFast(0, 0, Intro, rcRect, DDBLTFAST_NOCOLORKEY Or DDBLTFAST_WAIT)
End Sub

Function TankCollision(k, x, y As Integer) As Boolean
    If k = 0 Then
        If Abs(player(0).x + x - player(1).x) < 25 And Abs(player(0).y + y - player(1).y) < 25 Then
            TankCollision = True
            Exit Function
        End If
    End If
    If k = 1 Then
        If Abs(player(1).x + x - player(0).x) < 25 And Abs(player(1).y + y - player(0).y) < 25 Then
            TankCollision = True
            Exit Function
        End If
    End If
    TankCollision = False
End Function

Sub UpdateBullets()
    Dim ddrval As Long
    Dim rcRect As RECT
    Dim k As Integer
    
    For k = 0 To 9
        If bullet(k).lifetime > 0 Then ' move bullet
            If bullet(k).lifetime = 255 Then
                bullet(k).lifetime = 0
                player(bullet(k).owner).fired = player(bullet(k).owner).fired - 1
            Else
                bullet(k).lifetime = bullet(k).lifetime + 1
            End If
            
            bullet(k).x = bullet(k).x + bullet(k).xvel
            
            If bullet(k).x < 0 Or _
             (bullet(k).x + BULLET_RADIUS) > 639 Then
                bullet(k).xvel = -bullet(k).xvel
                bullet(k).x = bullet(k).x + bullet(k).xvel
                If bSound = True Then
                    If bullet(k).owner = 0 Then
                        hsoBounce.Stop
                        hsoBounce.SetCurrentPosition 0
                        PlayPanned hsoBounce, bullet(k).x
                    Else
                        hsoBounce2.Stop
                        hsoBounce2.SetCurrentPosition 0
                        PlayPanned hsoBounce2, bullet(k).x
                    End If
                End If
            Else
                If (bullet(k).xvel > 0 And bField(Int((bullet(k).x + BULLET_RADIUS) / 32), Int((bullet(k).y - 26) / 32)) = True) Or _
                 (bullet(k).xvel < 0 And bField(Int((bullet(k).x) / 32), Int((bullet(k).y - 26) / 32)) = True) Then
                    bullet(k).xvel = -bullet(k).xvel
                    bullet(k).x = bullet(k).x + bullet(k).xvel
                    If bSound = True Then
                        If bullet(k).owner = 0 Then
                            hsoBounce.Stop
                            hsoBounce.SetCurrentPosition 0
                            PlayPanned hsoBounce, bullet(k).x
                        Else
                            hsoBounce2.Stop
                            hsoBounce2.SetCurrentPosition 0
                            PlayPanned hsoBounce2, bullet(k).x
                        End If
                    End If
                End If
            End If

            bullet(k).y = bullet(k).y + bullet(k).yvel
            
            If bullet(k).y < 32 Or _
             (bullet(k).y + BULLET_RADIUS) > 479 Then
                bullet(k).yvel = -bullet(k).yvel
                bullet(k).y = bullet(k).y + bullet(k).yvel
                If bSound = True Then
                    If bullet(k).owner = 0 Then
                        hsoBounce.Stop
                        hsoBounce.SetCurrentPosition 0
                        PlayPanned hsoBounce, bullet(k).x
                    Else
                        hsoBounce2.Stop
                        hsoBounce2.SetCurrentPosition 0
                        PlayPanned hsoBounce2, bullet(k).x
                    End If
                End If
            Else
                If (bullet(k).yvel > 0 And bField(Int((bullet(k).x + 6) / 32), Int((bullet(k).y + BULLET_RADIUS - 32) / 32)) = True) Or _
                 (bullet(k).yvel < 0 And bField(Int((bullet(k).x + 6) / 32), Int((bullet(k).y - 32) / 32)) = True) Then
                    bullet(k).yvel = -bullet(k).yvel
                    bullet(k).y = bullet(k).y + bullet(k).yvel
                    If bSound = True Then
                        If bullet(k).owner = 0 Then
                            hsoBounce.Stop
                            hsoBounce.SetCurrentPosition 0
                            PlayPanned hsoBounce, bullet(k).x
                        Else
                            hsoBounce2.Stop
                            hsoBounce2.SetCurrentPosition 0
                            PlayPanned hsoBounce2, bullet(k).x
                        End If
                    End If
                End If
            End If
                
            rcRect.Left = 0
            rcRect.Top = 190
            rcRect.Right = 12
            rcRect.Bottom = 202

            ' blit bullet
            ddrval = Back.BltFast(bullet(k).x, bullet(k).y, Sprites, rcRect, DDBLTFAST_SRCCOLORKEY Or DDBLTFAST_WAIT)
        End If
    Next k
End Sub

Sub InitBullet(k, l As Integer)
    bullet(k).lifetime = 1
    bullet(k).owner = l

    Select Case player(l).direction
        Case 0:
            bullet(k).x = player(l).x + 14
            bullet(k).y = player(l).y - 7
            bullet(k).xvel = 0
            bullet(k).yvel = -6
        Case 1:
            bullet(k).x = player(l).x + 22
            bullet(k).y = player(l).y - 6
            bullet(k).xvel = 3
            bullet(k).yvel = -6
        Case 2:
            bullet(k).x = player(l).x + 28
            bullet(k).y = player(l).y - 2
            bullet(k).xvel = 6
            bullet(k).yvel = -6
        Case 3:
            bullet(k).x = player(l).x + 31
            bullet(k).y = player(l).y + 4
            bullet(k).xvel = 6
            bullet(k).yvel = -3
        Case 4:
            bullet(k).x = player(l).x + 33
            bullet(k).y = player(l).y + 12
            bullet(k).xvel = 6
            bullet(k).yvel = 0
        Case 5:
            bullet(k).x = player(l).x + 33
            bullet(k).y = player(l).y + 20
            bullet(k).xvel = 6
            bullet(k).yvel = 3
        Case 6:
            bullet(k).x = player(l).x + 30
            bullet(k).y = player(l).y + 29
            bullet(k).xvel = 6
            bullet(k).yvel = 6
        Case 7:
            bullet(k).x = player(l).x + 24
            bullet(k).y = player(l).y + 32
            bullet(k).xvel = 3
            bullet(k).yvel = 6
        Case 8:
            bullet(k).x = player(l).x + 14
            bullet(k).y = player(l).y + 33
            bullet(k).xvel = 0
            bullet(k).yvel = 6
        Case 9:
            bullet(k).x = player(l).x + 4
            bullet(k).y = player(l).y + 30
            bullet(k).xvel = -3
            bullet(k).yvel = 6
        Case 10:
            bullet(k).x = player(l).x - 2
            bullet(k).y = player(l).y + 27
            bullet(k).xvel = -6
            bullet(k).yvel = 6
        Case 11:
            bullet(k).x = player(l).x - 6
            bullet(k).y = player(l).y + 20
            bullet(k).xvel = -6
            bullet(k).yvel = 3
        Case 12:
            bullet(k).x = player(l).x - 7
            bullet(k).y = player(l).y + 12
            bullet(k).xvel = -6
            bullet(k).yvel = 0
        Case 13:
            bullet(k).x = player(l).x - 4
            bullet(k).y = player(l).y + 2
            bullet(k).xvel = -6
            bullet(k).yvel = -3
        Case 14:
            bullet(k).x = player(l).x
            bullet(k).y = player(l).y - 2
            bullet(k).xvel = -6
            bullet(k).yvel = -6
        Case 15:
            bullet(k).x = player(l).x + 6
            bullet(k).y = player(l).y - 6
            bullet(k).xvel = -3
            bullet(k).yvel = -6
    End Select
    If bullet(k).x < 0 Then
        bullet(k).x = 0
    End If
    If bullet(k).x > 639 - BULLET_RADIUS Then
        bullet(k).x = 639 - BULLET_RADIUS
    End If
    If bullet(k).y < 0 Then
        bullet(k).y = 0
    End If
    If bullet(k).y > 479 - BULLET_RADIUS Then
        bullet(k).y = 479 - BULLET_RADIUS
    End If
End Sub

Function CheckAccess(k, direction As Integer) As Boolean
    If direction = 0 Then
        If bField(Int((player(k).x + 7) / 32), Int((player(k).y - 34) / 32)) = False And bField(Int((player(k).x + 19) / 32), Int((player(k).y - 34) / 32)) = False And bField(Int((player(k).x + 31) / 32), Int((player(k).y - 34) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 1 Then
        If bField(Int((player(k).x + 15) / 32), Int((player(k).y - 34) / 32)) = False And bField(Int((player(k).x + 28) / 32), Int((player(k).y - 34) / 32)) = False And bField(Int((player(k).x + 39) / 32), Int((player(k).y - 27) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 2 Then
        If bField(Int((player(k).x + 24) / 32), Int((player(k).y - 34) / 32)) = False And bField(Int((player(k).x + 40) / 32), Int((player(k).y - 33) / 32)) = False And bField(Int((player(k).x + 40) / 32), Int((player(k).y - 16) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 3 Then
        If bField(Int((player(k).x + 32) / 32), Int((player(k).y - 33) / 32)) = False And bField(Int((player(k).x + 40) / 32), Int((player(k).y - 24) / 32)) = False And bField(Int((player(k).x + 40) / 32), Int((player(k).y - 10) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 4 Then
        If bField(Int((player(k).x + 40) / 32), Int((player(k).y - 25) / 32)) = False And bField(Int((player(k).x + 40) / 32), Int((player(k).y - 13) / 32)) = False And bField(Int((player(k).x + 40) / 32), Int((player(k).y - 1) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 5 Then
        If bField(Int((player(k).x + 40) / 32), Int((player(k).y - 17) / 32)) = False And bField(Int((player(k).x + 40) / 32), Int((player(k).y - 4) / 32)) = False And bField(Int((player(k).x + 33) / 32), Int((player(k).y + 7) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 6 Then
        If bField(Int((player(k).x + 40) / 32), Int((player(k).y - 8) / 32)) = False And bField(Int((player(k).x + 40) / 32), Int((player(k).y + 7) / 32)) = False And bField(Int((player(k).x + 22) / 32), Int((player(k).y + 8) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 7 Then
        If bField(Int((player(k).x + 15) / 32), Int((player(k).y + 8) / 32)) = False And bField(Int((player(k).x + 30) / 32), Int((player(k).y + 8) / 32)) = False And bField(Int((player(k).x + 39) / 32), Int((player(k).y - 5) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 8 Then
        If bField(Int((player(k).x + 7) / 32), Int((player(k).y + 8) / 32)) = False And bField(Int((player(k).x + 19) / 32), Int((player(k).y + 8) / 32)) = False And bField(Int((player(k).x + 31) / 32), Int((player(k).y + 8) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 9 Then
        If bField(Int((player(k).x - 1) / 32), Int((player(k).y + 2) / 32)) = False And bField(Int((player(k).x + 8) / 32), Int((player(k).y + 8) / 32)) = False And bField(Int((player(k).x + 26) / 32), Int((player(k).y + 8) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 10 Then
        If bField(Int((player(k).x - 2) / 32), Int((player(k).y - 10) / 32)) = False And bField(Int((player(k).x - 1) / 32), Int((player(k).y + 8) / 32)) = False And bField(Int((player(k).x + 18) / 32), Int((player(k).y + 8) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 11 Then
        If bField(Int((player(k).x - 2) / 32), Int((player(k).y - 14) / 32)) = False And bField(Int((player(k).x - 2) / 32), Int((player(k).y - 3) / 32)) = False And bField(Int((player(k).x + 10) / 32), Int((player(k).y + 7) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 12 Then
        If bField(Int((player(k).x - 2) / 32), Int((player(k).y - 25) / 32)) = False And bField(Int((player(k).x - 2) / 32), Int((player(k).y - 13) / 32)) = False And bField(Int((player(k).x - 2) / 32), Int((player(k).y - 1) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 13 Then
        If bField(Int((player(k).x - 2) / 32), Int((player(k).y - 7) / 32)) = False And bField(Int((player(k).x - 2) / 32), Int((player(k).y - 23) / 32)) = False And bField(Int((player(k).x + 7) / 32), Int((player(k).y - 33) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 14 Then
        If bField(Int((player(k).x - 1) / 32), Int((player(k).y - 34) / 32)) = False And bField(Int((player(k).x + 19) / 32), Int((player(k).y - 34) / 32)) = False And bField(Int((player(k).x - 2) / 32), Int((player(k).y - 14) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    If direction = 15 Then
        If bField(Int((player(k).x - 1) / 32), Int((player(k).y - 26) / 32)) = False And bField(Int((player(k).x + 12) / 32), Int((player(k).y - 34) / 32)) = False And bField(Int((player(k).x + 25) / 32), Int((player(k).y - 34) / 32)) = False Then
            CheckAccess = False
            Exit Function
        End If
    End If
    CheckAccess = True
End Function

Sub CheckFire()
    Dim k As Integer
    
    For k = 0 To 1
        If player(k).firetime > 0 Then ' update firetime
            player(k).firetime = player(k).firetime + 1
            If player(k).firetime > FIRE_DELAY Then
                player(k).firetime = 0
            End If
        End If
    Next k

    If (LastInput And KEY1_FIRE) And player(0).firetime = 0 And player(0).fired < player(0).bullets Then   ' player 1 fires
        If bSound = True Then
            hsoShoot.Stop
            hsoShoot.SetCurrentPosition 0
            PlayPanned hsoShoot, player(0).x
        End If
        player(0).firetime = 1
        player(0).fired = player(0).fired + 1
        For k = 0 To (MAX_BULLETS * 2) - 1  ' find free bullet
            If bullet(k).lifetime = 0 Then
                Exit For
            End If
        Next k
        InitBullet k, 0
    End If
    
    If (LastInput And KEY2_FIRE) And player(1).firetime = 0 And player(1).fired < player(1).bullets Then   ' player 2 fires
        If bSound = True Then
            hsoShoot.Stop
            hsoShoot.SetCurrentPosition 0
            PlayPanned hsoShoot, player(1).x
        End If
        player(1).firetime = 1
        player(1).fired = player(1).fired + 1
        For k = 0 To (MAX_BULLETS * 2) - 1  ' find free bullet
            If bullet(k).lifetime = 0 Then
                Exit For
            End If
        Next k
        InitBullet k, 1
    End If
End Sub

Sub MoveTanks()
    Dim k As Integer
    
    If (LastInput And KEY1_LEFT) And TimeTicks Mod 4 = 1 Then   ' player 1 turns left
        player(0).direction = player(0).direction - 1
        If player(0).direction = -1 Then
            player(0).direction = 15
        End If
    End If
    If (LastInput And KEY1_RIGHT) And TimeTicks Mod 4 = 1 Then  ' player 1 turns right
        player(0).direction = player(0).direction + 1
        If player(0).direction = 16 Then
            player(0).direction = 0
        End If
    End If
    If (LastInput And KEY2_LEFT) And TimeTicks Mod 4 = 1 Then ' player 2 turns left
        player(1).direction = player(1).direction - 1
        If player(1).direction = -1 Then
            player(1).direction = 15
        End If
    End If
    If (LastInput And KEY2_RIGHT) And TimeTicks Mod 4 = 1 Then ' player 2 turns right
        player(1).direction = player(1).direction + 1
        If player(1).direction = 16 Then
            player(1).direction = 0
        End If
    End If
    For k = 0 To 1
        If (k = 0 And ((LastInput And KEY1_UP) Or (LastInput And KEY1_DOWN))) Or (k = 1 And ((LastInput And KEY2_UP) Or (LastInput And KEY2_DOWN))) Then
            ' move wheels
            If player(k).wheels = 0 Then
                player(k).wheels = 1
            Else
                player(k).wheels = 0
            End If
            ' mirror tank for backward speed
            If (k = 0 And LastInput And KEY1_DOWN) Or (k = 1 And LastInput And KEY2_DOWN) Then
                If player(k).direction > 7 Then
                    player(k).direction = player(k).direction - 8
                Else
                    player(k).direction = player(k).direction + 8
                End If
            End If
            ' check directions and move
            If player(k).direction = 0 And player(k).y > 33 Then
                If CheckAccess(k, 0) = False And TankCollision(k, 0, -2) = False Then
                    player(k).y = player(k).y - 2
                End If
            End If
            If player(k).direction = 1 And player(k).y > 33 And player(k).x < 601 Then
                If CheckAccess(k, 1) = False And TankCollision(k, 1, -2) = False Then
                    player(k).x = player(k).x + 1
                    player(k).y = player(k).y - 2
                End If
            End If
            If player(k).direction = 2 And player(k).y > 33 And player(k).x < 600 Then
                If CheckAccess(k, 2) = False And TankCollision(k, 2, -2) = False Then
                    player(k).x = player(k).x + 2
                    player(k).y = player(k).y - 2
                End If
            End If
            If player(k).direction = 3 And player(k).y > 32 And player(k).x < 600 Then
                If CheckAccess(k, 3) = False And TankCollision(k, 2, -1) = False Then
                    player(k).x = player(k).x + 2
                    player(k).y = player(k).y - 1
                End If
            End If
            If player(k).direction = 4 And player(k).x < 600 Then
                If CheckAccess(k, 4) = False And TankCollision(k, 2, 0) = False Then
                    player(k).x = player(k).x + 2
                End If
            End If
            If player(k).direction = 5 And player(k).y < 441 And player(k).x < 600 Then
                If CheckAccess(k, 5) = False And TankCollision(k, 2, 1) = False Then
                    player(k).x = player(k).x + 2
                    player(k).y = player(k).y + 1
                End If
            End If
            If player(k).direction = 6 And player(k).y < 440 And player(k).x < 600 Then
                If CheckAccess(k, 6) = False And TankCollision(k, 2, 2) = False Then
                    player(k).x = player(k).x + 2
                    player(k).y = player(k).y + 2
                End If
            End If
            If player(k).direction = 7 And player(k).y < 440 And player(k).x < 601 Then
                If CheckAccess(k, 7) = False And TankCollision(k, 1, 2) = False Then
                    player(k).x = player(k).x + 1
                    player(k).y = player(k).y + 2
                End If
            End If
            If player(k).direction = 8 And player(k).y < 440 Then
                If CheckAccess(k, 8) = False And TankCollision(k, 0, 2) = False Then
                    player(k).y = player(k).y + 2
                End If
            End If
            If player(k).direction = 9 And player(k).y < 440 And player(k).x > 0 Then
                If CheckAccess(k, 9) = False And TankCollision(k, -1, 2) = False Then
                    player(k).x = player(k).x - 1
                    player(k).y = player(k).y + 2
                End If
            End If
            If player(k).direction = 10 And player(k).y < 440 And player(k).x > 1 Then
                If CheckAccess(k, 10) = False And TankCollision(k, -2, 2) = False Then
                    player(k).x = player(k).x - 2
                    player(k).y = player(k).y + 2
                End If
            End If
            If player(k).direction = 11 And player(k).y < 441 And player(k).x > 1 Then
                If CheckAccess(k, 11) = False And TankCollision(k, -2, 1) = False Then
                    player(k).x = player(k).x - 2
                    player(k).y = player(k).y + 1
                End If
            End If
            If player(k).direction = 12 And player(k).x > 1 Then
                If CheckAccess(k, 12) = False And TankCollision(k, -2, 0) = False Then
                    player(k).x = player(k).x - 2
                End If
            End If
            If player(k).direction = 13 And player(k).y > 32 And player(k).x > 1 Then
                If CheckAccess(k, 13) = False And TankCollision(k, -2, -1) = False Then
                    player(k).x = player(k).x - 2
                    player(k).y = player(k).y - 1
                End If
            End If
            If player(k).direction = 14 And player(k).y > 33 And player(k).x > 1 Then
                If CheckAccess(k, 14) = False And TankCollision(k, -2, -2) = False Then
                    player(k).x = player(k).x - 2
                    player(k).y = player(k).y - 2
                End If
            End If
            If player(k).direction = 15 And player(k).y > 33 And player(k).x > 0 Then
                If CheckAccess(k, 15) = False And TankCollision(k, -1, -2) = False Then
                    player(k).x = player(k).x - 1
                    player(k).y = player(k).y - 2
                End If
            End If
            ' mirror tank for backward speed
            If (k = 0 And LastInput And KEY1_DOWN) Or (k = 1 And LastInput And KEY2_DOWN) Then
                If player(k).direction > 7 Then
                    player(k).direction = player(k).direction - 8
                Else
                    player(k).direction = player(k).direction + 8
                End If
            End If
        End If
    Next k
End Sub

Sub UpdateFlames()
    Dim ddrval As Long
    Dim rcRect As RECT
    Dim k, l, r As Integer
        
    rcRect.Left = 474 + 24 * Int((ExplosionState Mod 16) / 4)
    rcRect.Top = 203
    rcRect.Right = rcRect.Left + 24
    rcRect.Bottom = rcRect.Top + 24

    ' blit flames
    ddrval = Back.BltFast(player(1 - WinningPlayer).x + 8, player(1 - WinningPlayer).y, Sprites, rcRect, DDBLTFAST_SRCCOLORKEY Or DDBLTFAST_WAIT)

    ' start a new cloud
    r = Int(Rnd * 12)
    If r = 3 Then
        For k = 0 To 19  ' find free cloud
            If cloud(k).y = 0 Then
                cloud(k).y = player(1 - WinningPlayer).y - 20
                cloud(k).x = player(1 - WinningPlayer).x
                Exit For
            End If
        Next k
    End If

    ' update clouds
    For l = 0 To 19
        If cloud(l).y > 0 Then
            cloud(l).y = cloud(l).y - 3
            cloud(l).x = cloud(l).x + Int(6 * Rnd) - 2
            If cloud(l).y < 3 Then
                cloud(l).y = 0
            End If
            rcRect.Left = 415 + Int((cloud(l).y Mod 16) / 8) * 29
            rcRect.Top = 201
            rcRect.Right = rcRect.Left + 27
            rcRect.Bottom = rcRect.Top + 27

            If cloud(l).x < 612 Then ' blit clouds
                ddrval = Back.BltFast(cloud(l).x, cloud(l).y, Sprites, rcRect, DDBLTFAST_SRCCOLORKEY Or DDBLTFAST_WAIT)
            End If
        End If
    Next l
End Sub

Sub CheckBonusCollision()
    Dim k As Integer
    For k = 0 To 1
        If Abs(player(k).x + 20 - (bonus.x * 32 + 16)) < 16 And Abs(player(k).y + 20 - (bonus.y * 32 + 48)) < 16 Then
            If bSound = True Then
                PlayPanned hsoBonus, player(k).x
            End If
            If player(k).bullets < MAX_BULLETS Then
                player(k).bullets = player(k).bullets + 1
            End If
            bonus.time = 0
        End If
    Next k
End Sub

Sub ShowBonus()
    Dim ddrval As Long
    Dim rcRect As RECT
    
    bonus.time = bonus.time - 1

    rcRect.Left = 512
    rcRect.Top = 156
    rcRect.Right = 544
    rcRect.Bottom = 188

    ' blit bonus item
    ddrval = Back.BltFast(bonus.x * 32, bonus.y * 32 + 32, Sprites, rcRect, DDBLTFAST_SRCCOLORKEY Or DDBLTFAST_WAIT)
End Sub

Sub ShowWinner()
    Dim ddrval As Long
    Dim rcRect As RECT
    Dim y As Integer
    
    rcRect.Left = 0
    rcRect.Top = 201 + 27 * WinningPlayer
    rcRect.Right = 408
    rcRect.Bottom = rcRect.Top + 28

    If ExplosionState < 162 Then
        y = 454 - ((ExplosionState - 100) * 4)
    Else
        y = 213
    End If

    ' blit winning player
    ddrval = Back.BltFast(148, y, Sprites, rcRect, DDBLTFAST_SRCCOLORKEY Or DDBLTFAST_WAIT)
    
    y = 479 - y

    rcRect.Left = 414
    rcRect.Top = 234
    rcRect.Right = 624
    rcRect.Bottom = 250

    ' blit 'F1 = new game'
    ddrval = Back.BltFast(212, y, Sprites, rcRect, DDBLTFAST_SRCCOLORKEY Or DDBLTFAST_WAIT)
End Sub

Sub FlipScreen()
   ' Flip the surfaces
    Primary.Flip Nothing, DDFLIP_WAIT
End Sub

' UpdateFrame
'
' Decide what needs to be blitted next,
' then flip the buffers.
'
Sub UpdateFrame()
    On Local Error GoTo errOut
    
    If bInit = False Then
        Exit Sub
    End If
    
    If GameState = 0 Then
        If bKeyPressed = True Then
            InitLevel
        Else
            ShowIntroPic
        End If
    End If
    
    If GameState = 1 Then
        CollisionCheck
        CheckFire
        MoveTanks
        UpdateBack
        UpdateTanks
        UpdateBullets
        BlitScore
        ' Place a new bonus item
        If bonus.time = 0 And TimeTicks Mod 640 = 1 Then
            bonus.x = Int(20 * Rnd)
            bonus.y = Int(14 * Rnd)
            ' Only show it if it's not on a block
            If bField(bonus.x, bonus.y) = False Then
                bonus.time = 350
            End If
        End If
        If bonus.time > 0 Then
            ShowBonus
            CheckBonusCollision
        End If
    End If
  
    If GameState = 2 Then
        UpdateBack
        UpdateTanks
        BlitScore
        UpdateBullets
        UpdateFlames
        ExplosionState = ExplosionState + 1
        If ExplosionState = 500 Then
            ExplosionState = 300
        End If
        If ExplosionState > 100 Then
            ShowWinner
        End If
    End If
    
    FlipScreen
    TimeTicks = TimeTicks + 1

errOut:
End Sub

Sub UpdateBack()
    Dim rcRect As RECT
    Dim ddrval As Long
        
    ' Redraw the field background
    rcRect.Left = 0
    rcRect.Top = 0
    rcRect.Right = 640
    rcRect.Bottom = 480
    
    ddrval = Back.BltFast(0, 0, Achter, rcRect, DDBLTFAST_NOCOLORKEY Or DDBLTFAST_WAIT)
End Sub

Sub CleanUp()
    Call ShowMouse
    Call dd.RestoreDisplayMode
    Call dd.SetCooperativeLevel(Me.hWnd, DDSCL_NORMAL)
    End
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    bKeyPressed = True
    Select Case KeyCode
        Case vbKeyDown
            LastInput = LastInput Or KEY2_DOWN
        Case vbKeyLeft
            LastInput = LastInput Or KEY2_LEFT
        Case vbKeyRight
            LastInput = LastInput Or KEY2_RIGHT
        Case vbKeyUp
            LastInput = LastInput Or KEY2_UP
        Case vbKeyReturn
            LastInput = LastInput Or KEY2_FIRE
        Case vbKeyW
            LastInput = LastInput Or KEY1_UP
        Case vbKeyA
            LastInput = LastInput Or KEY1_LEFT
        Case vbKeyD
            LastInput = LastInput Or KEY1_RIGHT
        Case vbKeyX
            LastInput = LastInput Or KEY1_DOWN
        Case vbKeyQ
            LastInput = LastInput Or KEY1_FIRE
        Case vbKey0
        If player(1).power < 12 Then
          player(1).power = player(1).power + 1
        End If
        Case vbKey1
        If player(0).power < 12 Then
          player(0).power = player(0).power + 1
        End If
        Case vbKeyF1
            InitLevel
        Case vbKeyF2
            If bSound = True Then
                bSound = False
            Else
                bSound = True
            End If
        Case vbKeyF3
            If bRevStereo = True Then
                bRevStereo = False
            Else
                bRevStereo = True
            End If
        Case vbKeyEscape
            CleanUp
        End Select
End Sub


Private Sub Form_KeyUp(KeyCode As Integer, Shift As Integer)
    bKeyPressed = False
    Select Case KeyCode
        Case vbKeyLeft
            LastInput = LastInput And Not KEY2_LEFT
        Case vbKeyRight
            LastInput = LastInput And Not KEY2_RIGHT
        Case vbKeyUp
            LastInput = LastInput And Not KEY2_UP
        Case vbKeyDown
            LastInput = LastInput And Not KEY2_DOWN
        Case vbKeyReturn
            LastInput = LastInput And Not KEY2_FIRE
        Case vbKeyA
            LastInput = LastInput And Not KEY1_LEFT
        Case vbKeyD
            LastInput = LastInput And Not KEY1_RIGHT
        Case vbKeyW
            LastInput = LastInput And Not KEY1_UP
        Case vbKeyX
            LastInput = LastInput And Not KEY1_DOWN
        Case vbKeyQ
            LastInput = LastInput And Not KEY1_FIRE
        End Select
End Sub

'
' Init - do work required for every instance of the application:
'                create the window, initialize data
'                and then stay in a loop
Sub Init()
On Local Error GoTo errOut

    Call HideMouse
    
    Set dd = dx.DirectDrawCreate("")
    Me.Show
    
    'set mode to fullscreen 640x480x16. note that using 640x480x8 causes wrong color quantization
    Call dd.SetCooperativeLevel(Me.hWnd, DDSCL_FULLSCREEN Or DDSCL_EXCLUSIVE)
    Call dd.SetDisplayMode(640, 480, 16, 0, DDSDM_DEFAULT)
        
    'get the screen surface and create a back buffer too
    ddsd1.lFlags = DDSD_CAPS Or DDSD_BACKBUFFERCOUNT
    ddsd1.ddsCaps.lCaps = DDSCAPS_PRIMARYSURFACE Or DDSCAPS_FLIP Or DDSCAPS_COMPLEX
    ddsd1.lBackBufferCount = 1
    Set Primary = dd.CreateSurface(ddsd1)
    
    'Get the backbuffer
    Dim caps As DDSCAPS2
    caps.lCaps = DDSCAPS_BACKBUFFER
    Set Back = Primary.GetAttachedSurface(caps)
    
    'load the bitmap into a surface - background
    ddsd2.lFlags = DDSD_CAPS
    ddsd2.ddsCaps.lCaps = DDSCAPS_OFFSCREENPLAIN
    Set Achter = dd.CreateSurfaceFromFile("background.bmp", ddsd2)
      
    'load the bitmap into a surface - intro
    Set Intro = dd.CreateSurfaceFromFile("intropic.bmp ", ddsd2)
            
    'load the bitmap into a surface - sprites
    ddsd2.lHeight = 256
    Set Sprites = dd.CreateSurfaceFromFile("sprites.bmp ", ddsd2)
    
    'use black for transparent color key which is on
    'the source bitmap -> use src keying
    Dim key As DDCOLORKEY
    key.low = 0
    key.high = 0
    Sprites.SetColorKey DDCKEY_SRCBLT, key
                                                    
    Randomize
    InitSound
    
    bInit = True
    bActive = True
    bKeyPressed = False
    bRevStereo = False
    bSound = True
    GameState = 0

    Do While bActive
        UpdateFrame
        DoEvents
    Loop

errOut:
    CleanUp
End Sub

Private Sub Form_Load()
    Init
End Sub
