Attribute VB_Name = "Module1"
'   Option Explicit -   
'      ...
' ,     , 
'  -      !
Option Explicit

' ************************************************
' *   Robert Wright - <rob@xenonic.com> *
' *      -             *
' *               - http://vladikcomper.narod.ru *
' ************************************************

' ************************************************
' *         ->   !!! <-         *
' *        *
' * VB  ( )       *
' * . , ,       *
' *                 *
' *  ,          *
' *  .                                *
' *                                              *
' * ,   ,     *
' *    PSC!                              *
' ************************************************

'  :
' v2a -   /
' v2  -     , 
'        ,  
'       ,   /
'       ,    , 
'          .
' v1  - , .

'    ;-)
Public Declare Function SetWindowRgn Lib "user32" (ByVal hwnd As Long, ByVal hRgn As Long, ByVal bRedraw As Boolean) As Long
'    
Public Declare Function CreateRoundRectRgn Lib "gdi32" (ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long, ByVal X3 As Long, ByVal Y3 As Long) As Long
'        
Public Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
'   ,   
Public Declare Function ReleaseCapture Lib "user32" () As Long
'    - 
Public Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, Y, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
'   
Public Declare Function GetCursorPos Lib "user32" (lpPoint As PointAPI) As Long
'   
Public Const HWND_TOPMOST = -1
Public Const HWND_NOTOPMOST = -2
Public Const SWP_NOMOVE = &H2
Public Const SWP_NOSIZE = &H1
Public Const SWP_NOACTIVATE = &H10
Public Const SWP_SHOWWINDOW = &H40
Public Const TOPMOST_FLAGS = SWP_NOMOVE Or SWP_NOSIZE

Public Type PointAPI
    X As Long
    Y As Long
End Type

Dim Resizable As Integer

Public Sub AlwaysOnTop(TheForm As Form, Toggle As Boolean)
' TheForm:  ,     -
' Toggle:   True:  , False: 
    
    If Toggle = True Then
        SetWindowPos TheForm.hwnd, HWND_TOPMOST, 0, 0, 0, 0, TOPMOST_FLAGS
    Else
        SetWindowPos TheForm.hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, TOPMOST_FLAGS
    End If
End Sub

Public Sub DoDrag(TheForm As Form)
' TheForm:     
    
    If TheForm.WindowState <> vbMaximized Then
        ReleaseCapture
        SendMessage TheForm.hwnd, &HA1, 2, 0&
    End If
End Sub

Public Sub MakeWindow(TheForm As Form, IsResizable As Boolean)
' TheForm:           ,      
' IsResizable:       True:    

'   
    Dim FormWidth As Long
    Dim FormHeight As Long
    Dim Temp As Integer

'   ?
    Resizable = IIf(IsResizable = True, 1, 0)
    
'  -   
    FormWidth = (TheForm.Width / Screen.TwipsPerPixelX)
    FormHeight = (TheForm.Height / Screen.TwipsPerPixelY)
    
'  
    TheForm.BackColor = RGB(207, 207, 207)
    TheForm.Caption = TheForm!lblTitle.Caption
    
'   
    TheForm!lblTitle.Left = 16
    TheForm!lblTitle.Top = 7
    
'    
    DoTransparency TheForm
    
'     
    With TheForm!imgTitleLeft
        .Top = 0
        .Left = 0
    End With
    
    With TheForm!imgTitleRight
        .Top = 0
        .Left = FormWidth - 19
    End With
    
    With TheForm!imgTitleMain
        .Top = 0
        .Left = 19
        .Width = FormWidth - 19
    End With
    
    With TheForm!imgWindowLeft
        .Top = 30
        .Left = 0
        .Height = FormHeight - 60
    End With
    
    With TheForm!imgWindowBottomLeft
        .Top = FormHeight - 30
        .Left = 0
    End With
    
    With TheForm!imgWindowBottom
        .Top = FormHeight - 30
        .Left = 19
        .Width = FormWidth - 38
    End With
    
    With TheForm!imgWindowBottomRight
        .Top = FormHeight - 30
        .Left = FormWidth - 19
    End With
    
    With TheForm!imgWindowRight
        .Top = 30
        .Left = FormWidth - 19
        .Height = FormHeight - 38
    End With
    
'    (, , )
    With TheForm!imgTitleClose
        .Top = 8
        .Left = FormWidth - 22
    End With
    
    With TheForm!imgTitleMaxRestore
        .Top = 8
        .Left = FormWidth - 39
    End With
    
    With TheForm!imgTitleMinimize
        .Top = 8
        .Left = FormWidth - 56
    End With
    
    With TheForm!imgTitleHelp
        .Top = 8
        .Left = FormWidth - 73
    End With
    
'   
    If IsResizable = True Then
        For Temp = 0 To 7
            TheForm!Resizer(Temp).Visible = True
        Next Temp
        
        With TheForm!Resizer(0)
            .Top = 30
            .Left = 0
            .Height = FormHeight - 60
        End With
        
        With TheForm!Resizer(1)
            .Top = 30
            .Left = FormWidth - 5
            .Height = FormHeight - 60
        End With
        
        With TheForm!Resizer(2)
            .Top = 0
            .Left = 19
            .Width = FormWidth - 39
        End With
        
        With TheForm!Resizer(3)
            .Top = FormHeight - 5
            .Left = 19
            .Width = FormWidth - 39
        End With
        
        With TheForm!Resizer(4)
            .Top = FormHeight - 11
            .Left = FormWidth - 11
        End With
        
        With TheForm!Resizer(5)
            .Top = FormHeight - 11
            .Left = 0
        End With
        
        With TheForm!Resizer(6)
            .Top = 0
            .Left = FormWidth - 11
        End With
        
        With TheForm!Resizer(7)
            .Top = 0
            .Left = 0
        End With
    End If
End Sub

Public Sub DoTransparency(TheForm As Form)
' TheForm:  ,     
    
    Dim TempRegions(6) As Long
    Dim FormWidthInPixels As Long
    Dim FormHeightInPixels As Long
    Dim a
    
'  -     
    FormWidthInPixels = TheForm.Width / Screen.TwipsPerPixelX
    FormHeightInPixels = TheForm.Height / Screen.TwipsPerPixelY
    
' , , 
    a = CreateRoundRectRgn(0, 0, FormWidthInPixels, FormHeightInPixels, 24, 24)
    a = SetWindowRgn(TheForm.hwnd, a, True)
End Sub

Public Sub ResizeForm(TheForm As Form, OldCursorPos As PointAPI, NewCursorPos As PointAPI, ResizeMode As Integer)
On Error Resume Next
    
' TheForm:      ,     
' OldCursorPos:    (MouseDown)
' NewCursorPos:    (MouseUp)
' ResizeMode:   0 -  
'               1 -  
'               2 -  
'               3 -  
'               4 -   
'               5 -   
'               6 -   
'               7 -   
    
'  
    Dim DifferenceX
    Dim DifferenceY
    
'    
    DifferenceX = (NewCursorPos.X - OldCursorPos.X) * Screen.TwipsPerPixelX
    DifferenceY = (NewCursorPos.Y - OldCursorPos.Y) * Screen.TwipsPerPixelY
    
' 
    Select Case ResizeMode
    Case 0
        TheForm.Move TheForm.Left + DifferenceX, TheForm.Top, TheForm.Width - DifferenceX, TheForm.Height
    Case 1
        TheForm.Move TheForm.Left, TheForm.Top, TheForm.Width + DifferenceX, TheForm.Height
    Case 2
        TheForm.Move TheForm.Left, TheForm.Top + DifferenceY, TheForm.Width, TheForm.Height - DifferenceY
    Case 3
        TheForm.Move TheForm.Left, TheForm.Top, TheForm.Width, TheForm.Height + DifferenceY
    Case 4
        TheForm.Move TheForm.Left, TheForm.Top, TheForm.Width + DifferenceX, TheForm.Height + DifferenceY
    Case 5
        TheForm.Move TheForm.Left + DifferenceX, TheForm.Top, TheForm.Width - DifferenceX, TheForm.Height + DifferenceY
    Case 6
        TheForm.Move TheForm.Left, TheForm.Top + DifferenceY, TheForm.Width + DifferenceX, TheForm.Height - DifferenceY
    Case 7
        TheForm.Move TheForm.Left + DifferenceX, TheForm.Top + DifferenceY, TheForm.Width - DifferenceX, TheForm.Height - DifferenceY
    End Select
    
'   
    If TheForm.Width < 57 * Screen.TwipsPerPixelX Then TheForm.Width = 57 * Screen.TwipsPerPixelX
    If TheForm.Height < 90 * Screen.TwipsPerPixelY Then TheForm.Height = 90 * Screen.TwipsPerPixelY
    
'      
    MakeWindow TheForm, True
End Sub

Public Sub ChangeState(TheForm As Form)
' TheForm:  ,      
    
    If TheForm.WindowState = vbNormal Then
        TheForm.WindowState = vbMaximized
        TheForm!imgTitleMaxRestore.Picture = TheForm!imgTitleRestore.Picture
        MakeWindow TheForm, False
    Else
        TheForm.WindowState = vbNormal
        TheForm!imgTitleMaxRestore.Picture = TheForm!imgTitleMaximize.Picture
        MakeWindow TheForm, IIf(Resizable = 1, True, False)
    End If
End Sub
